# DX makefile
# CE2 component
#

COMP_NAME = $(CE2_ID)

#id's of the components this component depends on
$(COMP_NAME)_DEPEND_ON_APIS := $(TC_ID)

#paths of this component API include directories
$(COMP_NAME)_API_INCL_PATH := \
	$(BASE_PATH)CryptoEngines2_API/

#paths of the internal include directories
$(COMP_NAME)_INTERNAL_INCL_PATH := \
	$(BASE_PATH)CryptoEngines2/Inc/ \
	

#global flags for this component
$(COMP_NAME)_CCFLAGS := 
#project-specific flags for this component should be added to $($(COMP_NAME)_SPECIFIC_CCFLAGS) outside of this makefile

#the objects names without path or extension
$(COMP_NAME)_OBJ_NAMES := \
	CE2_AES CE2_C2 CE2_CMLA CE2_DES CE2_DH \
	CE2_ECPKI_BUILD CE2_ECPKI_DH CE2_ECPKI_ECDSA CE2_ECPKI_ELGAMAL CE2_ECPKI_KG \
	CE2_error CE2_HASH CE2_HMAC CE2_KDF CE2_OTF \
	CE2_RC4 CE2_RND CE2_RSA_BUILD CE2_RSA_KG CE2_RSA_PRIM \
	CE2_RSA_SCHEMES CE2_Utils CE2_UTIL_RSA_SCHEMES LLF_AES \
	LLF_C2 LLF_CMLA LLF_DES LLF_DH LLF_ECPKI_BUILD \
	LLF_ECPKI_Common LLF_ECPKI_DH LLF_ECPKI_ECDSA LLF_ECPKI_ELGAMAL LLF_ECPKI_KG \
	LLF_error LLF_HASH LLF_HMAC LLF_KDF LLF_OTF \
	LLF_RC4 LLF_RND LLF_RSA_BUILD LLF_RSA_Common LLF_RSA_KG \
	LLF_RSA_PRIM LLF_RSA_SCHEMES LLF_Utils

#Use the above specific settings for building the components properties with the standard rules:
include $(MF_PATH)DX_STD_RULES.inc

##  OBJECT RULES - ADD RULES FOR NEW SOURCE FILES
#   make sure to add obj_name to the above list: $(COMP_NAME)_OBJS
#   this is the template for rules:
#$(OUT_OBJ_PATH)<<OBJ_NAME>>.$(OBJEXT): $(HOST_PATH)<<SOURCE_PATH>>
#	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_AES.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_AES.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_C2.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_C2.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_CMLA.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_CMLA.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_DES.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_DES.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_DH.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_DH.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_ECPKI_BUILD.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_ECPKI_BUILD.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_ECPKI_DH.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_ECPKI_DH.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_ECPKI_ECDSA.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_ECPKI_ECDSA.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_ECPKI_ELGAMAL.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_ECPKI_ELGAMAL.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_ECPKI_KG.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_ECPKI_KG.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_error.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_error.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_HASH.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_HASH.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_HMAC.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_HMAC.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_KDF.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_KDF.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_OTF.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_OTF.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_RC4.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_RC4.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_RND.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_RND.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_RSA_BUILD.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_RSA_BUILD.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_RSA_KG.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_RSA_KG.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_RSA_PRIM.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_RSA_PRIM.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_RSA_SCHEMES.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_RSA_SCHEMES.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_Utils.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_Utils.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_UTIL_RSA_SCHEMES.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_UTIL_RSA_SCHEMES.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)CE2_XTS_AES.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/CE2_XTS_AES.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_AES.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_AES.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_C2.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_C2.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_CMLA.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_CMLA.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_DES.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_DES.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_DH.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_DH.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_ECPKI_BUILD.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_ECPKI_BUILD.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_ECPKI_Common.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_ECPKI_Common.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_ECPKI_DH.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_ECPKI_DH.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_ECPKI_ECDSA.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_ECPKI_ECDSA.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_ECPKI_ELGAMAL.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_ECPKI_ELGAMAL.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_ECPKI_KG.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_ECPKI_KG.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_error.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_error.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_HASH.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_HASH.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_HMAC.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_HMAC.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_KDF.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_KDF.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_OTF.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_OTF.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_RC4.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_RC4.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_RND.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_RND.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_RSA_BUILD.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_RSA_BUILD.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_RSA_Common.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_RSA_Common.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_RSA_KG.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_RSA_KG.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_RSA_PRIM.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_RSA_PRIM.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_RSA_SCHEMES.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_RSA_SCHEMES.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@

$(OUT_OBJ_PATH)LLF_Utils.$(OBJEXT): $(BASE_PATH)CryptoEngines2/Src/LLF_Utils.c
	$(CE2_CC_CMD) $< $(CCFLAG_OUTPUT) $@
